import flet as ft


def main(page: ft.Page):
    page.title = "Горячая перезагрузка Flet – ответ"
    page.vertical_alignment = ft.MainAxisAlignment.START
    page.horizontal_alignment = ft.CrossAxisAlignment.START

    page.add(
        ft.Text("Тема: Горячая перезагрузка Flet", size=22, weight="bold"),
        ft.Text(
            "По умолчанию команда `flet run` отслеживает только файл скрипта "
            "(тот .py, который ты указываешь)."
        ),
        ft.Text(
            "Флаг -d (или --directory) – заставляет Flet отслеживать все файлы "
            "в директории скрипта и перезапускать приложение при изменении любого из них."
        ),
        ft.Text(
            "Флаг -r (или --recursive) – рекурсивно отслеживает директорию скрипта "
            "и все её поддиректории."
        ),
        ft.Text(
            "Пример команды горячей перезагрузки всего проекта:",
            weight="bold",
        ),
        ft.Text("flet run main.py -d -r", selectable=True),
    )


if __name__ == "__main__":
    ft.app(target=main)
